﻿Imports System
Imports System.Collections.Generic

Public Class frmMain

    ' 受信バッファ
    Dim RcvBuffList As New List(Of String)
    Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

    '----------------------------------------------------------------------
    ' RSコマンド送信ルーチン
    '----------------------------------------------------------------------
    Sub SendSerialData(ByVal data As String)
        ' COMポートを開いていない場合は処理をとばす
        If Not SerialPort1.IsOpen Then
            Exit Sub
        End If

        ' [ESC]を送信
        SerialPort1.Write(Chr(27))

        ' 任意の文字列を送信
        SerialPort1.Write(data)

        ' [CR]を送信
        SerialPort1.Write(Chr(13))

        While SerialPort1.BytesToWrite > 0
            Application.DoEvents()
        End While
    End Sub

    '----------------------------------------------------------------------
    ' フォーム起動
    '----------------------------------------------------------------------
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' デフォルトはCOM1
        cmbPortSel.SelectedIndex = 0
    End Sub

    '----------------------------------------------------------------------
    ' COMポートの受信イベント
    '----------------------------------------------------------------------
    Private Sub SerialPort1_DataReceived(ByVal sender As System.Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        'Dim tmp As Char()
        Dim tmpList As New List(Of Char)
        Dim tmp As Char
        Dim STW As Stopwatch

        STW = New Stopwatch()

        ' COMポートから文字列を受信
        If e.EventType = IO.Ports.SerialData.Chars Then
            ' 最低限4バイトは必要
            If SerialPort1.BytesToRead >= 4 Then

                ' ESCを探す
                While SerialPort1.BytesToRead > 0
                    tmp = Chr(SerialPort1.ReadChar())
                    If tmp = Chr(27) Then
                        tmpList.Add(tmp)

                        ' ESCが見つかったので残りのバッファを読み込む(CRが見つかるまで）
                        STW.Stop()
                        STW.Start()
                        While True
                            tmp = Chr(SerialPort1.ReadChar())
                            tmpList.Add(tmp)
                            ' CRが見つかったので、読み込み終了（続きがあった場合も次回に回す）
                            If tmp = Chr(13) Then
                                Exit While
                            End If

                            ' 受信し始めて100ミリ秒経過したら終わり
                            If STW.ElapsedMilliseconds > 100 Then
                                ' ESC～CRまできっちり受信できなかったので、受信処理を中断
                                Exit Sub
                            End If
                        End While
                    End If
                End While

                If tmpList.Count >= 4 Then
                    ' LSW-RV64Uで使われているコマンド文字ならリストに追加(タイマーで処理)
                    If tmpList(1) = "b" Or tmpList(1) = "s" Or tmpList(1) = "w" Then
                        RcvBuffList.Add(tmpList(1) & tmpList(2))
                    ElseIf tmpList(1) = "c" Then
                        RcvBuffList.Add(tmpList(1) & tmpList(2) & tmpList(3))
                    End If
                End If
            End If
        End If
    End Sub

    '----------------------------------------------------------------------
    ' RGB1ボタン～Video3ボタンをクリック
    '----------------------------------------------------------------------
    Private Sub btnRGB1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnVideo3.Click, btnVideo2.Click, btnVideo1.Click, btnRGB3.Click, btnRGB2.Click, btnRGB1.Click
        If sender.Checked Then
            ' Tagに格納しておいた数字を利用
            SendSerialData("S" & sender.Tag)
        End If
    End Sub

    '----------------------------------------------------------------------
    ' ブラックアウトボタンクリック
    '----------------------------------------------------------------------
    Private Sub btnBlackOut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBlackOut.Click
        If btnBlackOut.Checked Then
            SendSerialData("B1")
        Else
            SendSerialData("B0")
        End If
    End Sub

    '----------------------------------------------------------------------
    ' 電源ボタンクリック
    '----------------------------------------------------------------------
    Private Sub btnPowerOnOff_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPowerOnOff.Click
        If btnPowerOnOff.Checked Then
            SendSerialData("W1")

            'すでに起動しているかもしれないのでステータス確認を行う
            SendSerialData("C")
        Else
            SendSerialData("W0")
        End If
    End Sub

    '----------------------------------------------------------------------
    ' COMポートから文字列を受信していないかチェックするタイマー
    '----------------------------------------------------------------------
    Private Sub tmrRcvBuff_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrRcvBuff.Tick
        Dim RcvBuff As String = ""

        tmrRcvBuff.Enabled = False

        ' バッファにコマンドがあるか？
        If RcvBuffList.Count > 0 Then
            ' 先頭から処理していく
            RcvBuff = RcvBuffList.Item(0)
            RcvBuffList.RemoveAt(0)

            Select Case RcvBuff(0)
                Case "w"    ' 電源ON/OFFの通知
                    ' 電源ON/OFFの変化
                    btnPowerOnOff.Checked = RcvBuff(1) = "1"

                Case "b"    ' ブラックアウトON/OFFの通知
                    If (btnPowerOnOff.Checked) Then
                        ' ブラックアウトON/OFFの変化
                        btnBlackOut.Checked = RcvBuff(1) = "1"
                    End If

                Case "s"    ' ソース変更の通知
                    If (btnPowerOnOff.Checked) Then
                        ' RGB1～Video3までの変化
                        Select Case RcvBuff(1)
                            Case "1"
                                btnRGB1.Checked = True
                            Case "2"
                                btnRGB2.Checked = True
                            Case "3"
                                btnRGB3.Checked = True
                            Case "4"
                                btnVideo1.Checked = True
                            Case "5"
                                btnVideo2.Checked = True
                            Case "6"
                                btnVideo3.Checked = True
                        End Select
                    End If

                Case "c"    ' ステータス確認応答
                    ' ブラックアウトON/OFFの変化
                    btnBlackOut.Checked = RcvBuff(1) = "1"
                    ' RGB1～Video3までの変化
                    Select Case RcvBuff(2)
                        Case "1"
                            btnRGB1.Checked = True
                        Case "2"
                            btnRGB2.Checked = True
                        Case "3"
                            btnRGB3.Checked = True
                        Case "4"
                            btnVideo1.Checked = True
                        Case "5"
                            btnVideo2.Checked = True
                        Case "6"
                            btnVideo3.Checked = True
                    End Select
            End Select
        End If

        tmrRcvBuff.Enabled = True
    End Sub

    '----------------------------------------------------------------------
    ' COMポートのオープン/クローズ
    '----------------------------------------------------------------------
    Private Sub rbtPortOpen_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rbtPortOpen.CheckedChanged
        If rbtPortOpen.Checked Then
            ' COMポートを開く場合
            SerialPort1.Close()
            SerialPort1.PortName = cmbPortSel.SelectedItem
            SerialPort1.Open()

            ' 電源ボタンは有効
            btnPowerOnOff.Enabled = True
        Else
            ' COMポートを閉じる場合
            ' 電源がONのままならOFFにする
            If btnPowerOnOff.Checked Then
                btnPowerOnOff.Checked = False
                SendSerialData("W0")
                While SerialPort1.BytesToRead > 0
                    Application.DoEvents()
                End While
                ' RS通信が完全に終わるまで少し待つ
                Sleep(50)
            End If

            ' ポートを閉じる
            SerialPort1.Close()

            ' 電源ボタンは無効
            btnPowerOnOff.Enabled = False
        End If
    End Sub

    '----------------------------------------------------------------------
    ' 電源ボタンのステータス変更
    '----------------------------------------------------------------------
    Private Sub btnPowerOnOff_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPowerOnOff.CheckStateChanged

        ' 電源がOFFになった場合はいったんすべてのボタンを浮かす
        If btnPowerOnOff.Checked = False Then
            btnBlackOut.Checked = False
            btnRGB1.Checked = False
            btnRGB2.Checked = False
            btnRGB3.Checked = False
            btnVideo1.Checked = False
            btnVideo2.Checked = False
            btnVideo3.Checked = False
        End If

        ' 電源が入っている場合に限り、各ボタンが押せる
        btnBlackOut.Enabled = btnPowerOnOff.Checked
        btnRGB1.Enabled = btnPowerOnOff.Checked
        btnRGB2.Enabled = btnPowerOnOff.Checked
        btnRGB3.Enabled = btnPowerOnOff.Checked
        btnVideo1.Enabled = btnPowerOnOff.Checked
        btnVideo2.Enabled = btnPowerOnOff.Checked
        btnVideo3.Enabled = btnPowerOnOff.Checked
    End Sub

    '----------------------------------------------------------------------
    ' フォームを閉じる時の処理
    '----------------------------------------------------------------------
    Private Sub frmMain_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        ' 電源が入りっぱなしだったらOFFにする
        If btnPowerOnOff.Checked Then
            rbtPortOpen.Checked = False
        End If

    End Sub

End Class