"""LMS-31D用シリアル制御サンプルコード
"""

# ******************************************************************************
# (c) 2023 LAND COMPUTER Co.,Ltd.
# SPDX-License-Identifier: BSD-3-Clause
#
# LMS-31D製品ページ：https://www.landcomp.co.jp/product/peripheral/hdmi/lms-31d/
#
# [2023/06/01] Ver.1.0.0.0
# ******************************************************************************

from cls_serial_for_lms31d import (
    SerialForLMS31D,
    result_power_state,
    result_source_state,
)

# ここでは制御の例として、
# 「COMポートオープン」→「オープンに成功した場合、31Dの電源がOFFであれば、電源ONする」→「電源ONに成功した場合、ソース未選択であればソース1を選択する」
# としています。

# LMS-31D用シリアルクラス　インスタンス生成
__serial_for_lms31d: SerialForLMS31D = SerialForLMS31D()


# 接続
if __serial_for_lms31d.try_open("COM6"):
    # 電源状態取得
    __result_power: result_power_state = __serial_for_lms31d.request_state_power()

    # 電源状態
    __power: bool = False

    # 成功可否確認
    if __result_power.result:
        # 電源状態保管
        __power = __result_power.power_state

        # 電源オフ確認
        if not __power:
            # 電源オン
            __power = __serial_for_lms31d.control_power(True)

    # 電源オン確認
    if __power:
        # ソース選択状態取得
        __result_source: result_source_state = (
            __serial_for_lms31d.request_state_source()
        )

        # 成功可否確認
        if __result_source.result:
            # ソース未選択
            if __result_source.source_state == 0:
                # ソース1選択
                __serial_for_lms31d.control_source(1)
